/**********
* File: CDGL_IDirect3DVertexBuffer9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DVertexBuffer9. 
					 This class is equivalent to IDirect3DVertexBuffer9 interface in Direct3D9. IDirect3DVertexBuffer9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 27Oct04

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DVERTEXBUFFER9_H__
#define __CDGL_IDIRECT3DVERTEXBUFFER9_H__

#include <Carbon/Carbon.h>

#ifndef LIB_CHANGES
#include "OZone/IVertexBuffer.h"
#include "OZone/GraphicsInit.h"
#else
#include "IVertexBuffer.h"
#include "GraphicsInit.h"
#endif	// LIB_CHANGES
#include "d3d9.h"

//Shilpa on 16 Nov 04
typedef struct
{
	long	f_lRangeSize;				// # of bytes in this VAR block
	void	*f_pDataBlockPtr;			// ptr to the memory that we're making VAR
	Boolean	f_bForceUpdate;			// true if data in VAR block needs updating
	Boolean	f_bActivated;				// set to true the first time we use it
}VertexArrayRangeType;

class CDGL_IDirect3DVertexBuffer9 : public IDirect3DVertexBuffer9
{
	public:
	
		CDGL_IDirect3DVertexBuffer9(IDirect3DDevice9 *pDevice, UINT Length, DWORD Usage, DWORD FVF, D3DPOOL pool);
		~CDGL_IDirect3DVertexBuffer9();
		
		//! IUnknown methods
		HRESULT QueryInterface(REFIID riid, void **ppvObj);
		ULONG AddRef();
		ULONG Release();
		
		//! IDirect3DResource9 methods
		HRESULT FreePrivateData(REFGUID refguid);
		HRESULT GetDevice(IDirect3DDevice9 **ppDevice);
		DWORD   GetPriority();
		HRESULT GetPrivateData(REFGUID refguid, void *pData, DWORD *pSizeOfData);
		D3DRESOURCETYPE GetType();
		void	PreLoad();
		DWORD   SetPriority(DWORD PriorityNew);
		HRESULT SetPrivateData(REFGUID refguid, CONST void *pData, DWORD SizeOfData, DWORD Flags);
		
		//! IDirect3DVertexBuffer9 methods
		HRESULT GetDesc(D3DVERTEXBUFFER_DESC *pDesc);
		HRESULT Lock(UINT OffsetToLock, UINT SizeToLock, void **ppbData, DWORD Flags);
		HRESULT Unlock();
		
		//! Additional methods
		BYTE*   GetVertexBuffer() { return m_pVtxBuffer;}
		GLuint  GetVARID() { return m_dVARid;} 
		VertexArrayRangeType GetVARData() { return m_VARRangeData; }
		
		// Baaaalaaaa
		IVertexBuffer  	GetSmartBuffer();
	
	private:
		
		IDirect3DDevice9 *		m_pDevice;
		BYTE		*			m_pVtxBuffer;
		UINT					m_lLength;
		DWORD					m_dwUsage;
		DWORD					m_dwFVF;
		D3DPOOL					m_pool;
		int						m_lRefCount;
		VertexArrayRangeType	m_VARRangeData; //Shilpa on 16 Nov 04
		GLuint					m_dVARid; //Shilpa on 24 Nov 04
		static GLuint			m_lVARCount;
	
		// Baaaalaaaa
		IVertexBuffer 			mVertexBuffer;
		
		
};

#endif //__CDGL_IDIRECT3DVERTEXBUFFER9_H__
